package ru.yandex.infra.auth.nanny;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import ru.yandex.infra.auth.Role;
import ru.yandex.infra.auth.RoleSubject;

public class NannyRole extends Role {

    private final Set<String> logins;
    private final Set<Long> groups;

    public NannyRole(String rolePath, String leaf, String uniqueId, Set<String> logins, Set<Long> groups) {
        super(rolePath, leaf, "", uniqueId);
        this.logins = logins;
        this.groups = groups;
    }

    public List<RoleSubject> getRoleSubjects() {
        return Stream.concat(
                logins.stream().map(login -> new RoleSubject(login, 0L, this)),
                groups.stream().map(group -> new RoleSubject("", group, this))
        ).collect(Collectors.toList());
    }

    public Set<String> getLogins() {
        return logins;
    }

    public Set<Long> getGroups() {
        return groups;
    }

}
