package ru.yandex.infra.auth.nanny;

import java.util.Collections;
import java.util.Set;

import ru.yandex.infra.auth.RoleSubject;
import ru.yandex.infra.auth.idm.service.IdmService;

public interface NannyService {
    void updateRoleSubject(RoleSubject roleSubject, IdmService.RequestType requestType);
    Set<NannyRole> getRolesWithSubjects(String projectId, String serviceName, String serviceUuid);
    void syncNannyServiceRoleIntoYP(NannyRole nannyRole);
    void syncNannyServiceAuthAttrsAsync(String serviceId, String commitMessage);
    boolean isNodesSyncEnabled();

    NannyService DISABLED = new NannyService() {
        @Override
        public void updateRoleSubject(RoleSubject roleSubject, IdmService.RequestType requestType) { }

        @Override
        public Set<NannyRole> getRolesWithSubjects(String projectId, String serviceName, String serviceUuid) {
            return Collections.emptySet();
        }

        @Override
        public void syncNannyServiceRoleIntoYP(NannyRole nannyRole) { }

        @Override
        public void syncNannyServiceAuthAttrsAsync(String serviceId, String commitMessage) { }

        @Override
        public boolean isNodesSyncEnabled() {
            return false;
        }
    };
}
