package ru.yandex.infra.auth.nanny;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import com.typesafe.config.Config;
import org.asynchttpclient.AsyncHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.infra.controller.metrics.GaugeRegistry;

public class ReadOnlyNannyApiImpl implements NannyApi {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyNannyApiImpl.class);

    private NannyApi nannyApi;

    public ReadOnlyNannyApiImpl(Config config, AsyncHttpClient httpClient, GaugeRegistry gaugeRegistry) {
        nannyApi = new NannyApiImpl(config, httpClient, gaugeRegistry);
    }

    @Override
    public CompletableFuture<NannyServiceInfo> getService(String serviceId) {
        return nannyApi.getService(serviceId);
    }

    @Override
    public CompletableFuture<NannyServiceInfo> getService(String serviceId, int maxAttemptsCount, Duration retryDelay) {
        return nannyApi.getService(serviceId, maxAttemptsCount, retryDelay);
    }

    @Override
    public CompletableFuture<List<NannyServiceInfo>> getAllServices(int offset, int count) {
        return nannyApi.getAllServices(offset, count);
    }

    @Override
    public CompletableFuture<List<NannyServiceInfo>> getAllServices(int offset, int count, int maxAttemptsCount,
                                                                    Duration retryDelay) {
        return nannyApi.getAllServices(offset, count, maxAttemptsCount, retryDelay);
    }

    @Override
    public CompletableFuture<Set<String>> getAllServices() {
        return nannyApi.getAllServices();
    }

    @Override
    public CompletableFuture<Set<String>> getAllServices(int maxAttemptsCount, Duration retryDelay) {
        return nannyApi.getAllServices(maxAttemptsCount, retryDelay);
    }

    @Override
    public CompletableFuture<NannyServiceInfo> updateService(NannyServiceInfo service) {
        LOG.info("[readonly mode] Operation skipped: updateServices ({})", service);
        return CompletableFuture.completedFuture(service);
    }
}
