package ru.yandex.infra.auth.servlets;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.infra.auth.idm.service.IdmService;
import ru.yandex.infra.auth.idm.service.IdmServiceResponse;

public final class IdmAddRemoveMembershipServlet extends IdmServlet {

    public IdmAddRemoveMembershipServlet(
            IdmService service,
            IdmAuthorization authorizationStrategy,
            IdmService.RequestType requestType) {
        super(service, authorizationStrategy, requestType);
    }

    @Override
    protected String doPostInternal(HttpServletRequest req) throws IOException {

        String data = req.getParameterMap().get("data")[0];

        IdmServiceResponse result = service.processMemberships(data, requestType);
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(result);
    }
}
