package ru.yandex.infra.auth.servlets;

import java.io.IOException;
import java.util.Optional;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.infra.auth.idm.service.IdmService;
import ru.yandex.infra.auth.idm.service.IdmServiceResponse;

public final class IdmAddRemoveRoleServlet extends IdmServlet {
    public IdmAddRemoveRoleServlet(
            IdmService service,
            IdmAuthorization authorizationStrategy,
            IdmService.RequestType requestType) {
        super(service, authorizationStrategy, requestType);
    }

    @Override
    protected String doPostInternal(HttpServletRequest req) throws IOException {

        Optional<String> login = Optional.ofNullable(req.getParameter("login"));
        String group = req.getParameter("group");
        Optional<Long> groupId = Optional.ofNullable(group == null ? null : Long.parseLong(group));
        String roleJson = req.getParameter("role");
        String uniqueId = req.getParameter("unique_id");
        if (uniqueId == null) {
            uniqueId = "";
        }

        IdmServiceResponse result = service.addOrRemoveRole(login, groupId, roleJson, uniqueId, requestType);
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(result);
    }

}
