package ru.yandex.infra.auth.servlets;

import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.common.collect.Sets;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

import static org.apache.http.HttpStatus.SC_FORBIDDEN;

public class IdmCertificateAutorization implements IdmAuthorization {
    private static final Logger LOG = LoggerFactory.getLogger(IdmCertificateAutorization.class);
    private static final String SSL_SUBJECT_HEADER = "X-Qloud-SSL-Subject";
    private final Set<String> validCNs;

    public IdmCertificateAutorization(String validSubject) {
        validCNs = Sets.newHashSet(validSubject.split(";"));
        LOG.info("Certificate authorization: validCNs {}", validCNs);
    }

    private void prepareResponse(HttpServletResponse resp, String message) {
        LOG.warn(message);
        resp.setStatus(SC_FORBIDDEN);
    }

    @Override
    public boolean checkAuthorization(HttpServletRequest req, HttpServletResponse resp) {
        String subject = req.getHeader(SSL_SUBJECT_HEADER);
        if (subject == null) {
            prepareResponse(resp, "Cannot parse certificate. Missing header: " + SSL_SUBJECT_HEADER);
            return false;
        }
        final String[] dnParts = subject.split("[/,]");
        final String prefix = "CN=";
        for (String part : dnParts) {
            part = part.trim();
            if (part.startsWith(prefix)) {
                final String cn = part.substring(prefix.length()).trim();
                if (!validCNs.contains(cn)) {
                    prepareResponse(resp, "Wrong or missing certificate " + cn);
                    return false;
                }
                return true;
            }
        }
        prepareResponse(resp, "Cannot parse certificate. Wrong subject: " + subject);
        return false;
    }
}
