package ru.yandex.infra.auth.servlets;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.infra.auth.idm.service.IdmMembershipsResponse;
import ru.yandex.infra.auth.idm.service.IdmService;

public final class IdmGetMembershipsServlet extends IdmServlet {

    public IdmGetMembershipsServlet(IdmService idmService, IdmAuthorization authorizationStrategy) {
        super(idmService, authorizationStrategy, IdmService.RequestType.GET_MEMBERSHIPS);
    }

    @Override
    protected String doGetInternal(HttpServletRequest req) throws IOException {
        IdmMembershipsResponse roles = service.getAllMemberships();
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(roles);
    }
}
