package ru.yandex.infra.auth.servlets;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.infra.auth.idm.service.IdmRolesResponse;
import ru.yandex.infra.auth.idm.service.IdmService;

public final class IdmGetRolesServlet extends IdmServlet {
    public IdmGetRolesServlet(IdmService idmService, IdmAuthorization authorizationStrategy) {
        super(idmService, authorizationStrategy, IdmService.RequestType.GET_ALL_ROLES);
    }

    @Override
    protected String doGetInternal(HttpServletRequest req) throws IOException {
        IdmRolesResponse roles = service.getRoles();
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(roles);
    }
}
