package ru.yandex.infra.auth.servlets;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.infra.auth.idm.service.IdmInfoResponse;
import ru.yandex.infra.auth.idm.service.IdmService;

public final class IdmInfoServlet extends IdmServlet {
    public IdmInfoServlet(IdmService idmService, IdmAuthorization authorizationStrategy) {
        super(idmService, authorizationStrategy, IdmService.RequestType.INFO);
    }

    @Override
    protected String doGetInternal(HttpServletRequest req) throws IOException {
        IdmInfoResponse rolesTree = service.getInfo();
        return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(rolesTree);
    }
}

