package ru.yandex.infra.auth.servlets;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.infra.auth.tvm.TvmTicketParser;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

import static org.apache.http.HttpStatus.SC_FORBIDDEN;


public class IdmTvmAuthorization implements IdmAuthorization {
    private static final Logger LOG = LoggerFactory.getLogger(IdmTvmAuthorization.class);
    private static final String TVM_TICKET_HEADER = "X-Ya-Service-Ticket";

    private final TvmTicketParser tvmTicketParser;

    public IdmTvmAuthorization(TvmTicketParser serviceContextProvider) {
        LOG.info("TVM authorization is in USE");
        this.tvmTicketParser = serviceContextProvider;
    }

    @Override
    public boolean checkAuthorization(HttpServletRequest req, HttpServletResponse resp) {
        String ticket = req.getHeader(TVM_TICKET_HEADER);
        if (ticket == null) {
            LOG.warn("Cannot parse TVM ticket. Missing header: " + TVM_TICKET_HEADER);
            resp.setStatus(SC_FORBIDDEN);
            return false;
        }

        if (!tvmTicketParser.parseTicket(ticket)) {
            resp.setStatus(SC_FORBIDDEN);
            return false;
        }

        return true;
    }
}

