package ru.yandex.infra.auth.staff;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
class GetGroupsResponse {
    private final List<StaffGroup> results;
    private final Integer page;
    private final Integer pages;
    private final Integer total;

    GetGroupsResponse(@JsonProperty("result") List<StaffGroup> results,
                      @JsonProperty("page") Integer page,
                      @JsonProperty("pages") Integer pages,
                      @JsonProperty("total") Integer total) {
        this.results = results;
        this.total = total;
        this.page = page;
        this.pages = pages;
    }

    public List<StaffGroup> getResults() {
        return results;
    }

    public Integer getPage() {
        return page;
    }

    public Integer getPages() {
        return pages;
    }

    public Integer getTotal() {
        return total;
    }
}
