package ru.yandex.infra.auth.staff;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class StaffGroup {
    private final Long id;
    private final ObjectWithId abcService;
    private final ObjectWithId department;
    private final String roleScope;
    private final String url;
    private final StaffGroup parent;

    public StaffGroup(@JsonProperty("id") Long id,
               @JsonProperty("role_scope") String roleScope,
               @JsonProperty("url") String url,
               @JsonProperty("service") ObjectWithId abcService,
               @JsonProperty("department") ObjectWithId department,
               @JsonProperty("parent") StaffGroup parent) {

        this.id = id;
        this.abcService = abcService;
        this.department = department;
        this.roleScope = roleScope;
        this.url = url;
        this.parent = parent;
    }

    public Long getId() {
        return id;
    }

    public ObjectWithId getAbcService() {
        return abcService;
    }

    public String getRoleScope() {
        return roleScope;
    }

    public String getUrl() {
        return url;
    }

    public StaffGroup getParent() {
        return parent;
    }

    public ObjectWithId getDepartment() {
        return department;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ObjectWithId {
        private final String id;

        public ObjectWithId(@JsonProperty("id") String id) {
            this.id = id;
        }

        public String getId() {
            return id;
        }
    }

    @Override
    public String toString() {
        return "StaffGroup{" +
                "id=" + id +
                ", abcService=" + abcService +
                ", department=" + department +
                ", roleScope='" + roleScope + '\'' +
                ", url='" + url + '\'' +
                ", parent=" + parent +
                '}';
    }
}
