package ru.yandex.infra.auth.yp;

import ru.yandex.yp.model.YpObjectType;

import static java.lang.String.format;

public class MissedYpObjectException extends RuntimeException {
    private final YpObjectType objectType;
    private final String id;

    public MissedYpObjectException(String id, YpObjectType objectType) {
        super(format("%s with id %s doesn't exist", objectType, id), null);
        this.id = id;
        this.objectType = objectType;
    }

    public YpObjectType getObjectType() {
        return objectType;
    }

    public String getId() {
        return id;
    }
}
