package ru.yandex.infra.auth.yp;

import ru.yandex.infra.controller.dto.NannyServiceMeta;
import ru.yandex.infra.controller.dto.ProjectMeta;
import ru.yandex.infra.controller.dto.SchemaMeta;
import ru.yandex.infra.controller.dto.StageMeta;
import ru.yandex.infra.controller.yp.YpObjectRepository;
import ru.yandex.infra.controller.yp.YpTransactionClient;
import ru.yandex.yp.client.api.DataModel;
import ru.yandex.yp.client.api.TNannyServiceSpec;
import ru.yandex.yp.client.api.TNannyServiceStatus;
import ru.yandex.yp.client.api.TProjectSpec;
import ru.yandex.yp.client.api.TProjectStatus;
import ru.yandex.yp.client.api.TStageSpec;
import ru.yandex.yp.client.api.TStageStatus;

public class YpClients {
    private final YpTransactionClient ypTransactionClient;
    private final YpGroupsClient groupsClient;

    private final YpObjectRepository<ProjectMeta, TProjectSpec, TProjectStatus> projectRepository;
    private final YpObjectRepository<StageMeta, TStageSpec, TStageStatus> stageRepository;
    private final YpObjectRepository<SchemaMeta, DataModel.TUserSpec, DataModel.TUserStatus> userRepository;
    private final YpObjectRepository<NannyServiceMeta, TNannyServiceSpec, TNannyServiceStatus> nannyServiceRepository;
    private final YpObjectRepository<SchemaMeta, DataModel.TGroupSpec, DataModel.TGroupStatus> groupRepository;

    public YpClients(YpTransactionClient ypTransactionClient, YpGroupsClient groupsClient) {
        this (ypTransactionClient, groupsClient, null, null, null, null, null);
    }

    public YpClients(YpTransactionClient ypTransactionClient, YpGroupsClient groupsClient,
                     YpObjectRepository<ProjectMeta, TProjectSpec, TProjectStatus> projectRepository,
                     YpObjectRepository<StageMeta, TStageSpec, TStageStatus> stageRepository,
                     YpObjectRepository<SchemaMeta, DataModel.TUserSpec, DataModel.TUserStatus> userRepository,
                     YpObjectRepository<NannyServiceMeta, TNannyServiceSpec, TNannyServiceStatus> nannyServiceRepository,
                     YpObjectRepository<SchemaMeta, DataModel.TGroupSpec, DataModel.TGroupStatus> groupRepository) {
        this.ypTransactionClient = ypTransactionClient;
        this.groupsClient = groupsClient;
        this.projectRepository = projectRepository;
        this.stageRepository = stageRepository;
        this.userRepository = userRepository;
        this.nannyServiceRepository = nannyServiceRepository;
        this.groupRepository = groupRepository;
    }

    public YpTransactionClient getYpTransactionClient() {
        return ypTransactionClient;
    }

    public YpGroupsClient getGroupsClient() {
        return groupsClient;
    }

    public YpObjectRepository<ProjectMeta, TProjectSpec, TProjectStatus> getProjectRepository() {
        return projectRepository;
    }

    public YpObjectRepository<StageMeta, TStageSpec, TStageStatus> getStageRepository() {
        return stageRepository;
    }

    public YpObjectRepository<SchemaMeta, DataModel.TUserSpec, DataModel.TUserStatus> getUserRepository() {
        return userRepository;
    }

    public YpObjectRepository<NannyServiceMeta, TNannyServiceSpec, TNannyServiceStatus> getNannyServiceRepository() {
        return nannyServiceRepository;
    }

    public YpObjectRepository<SchemaMeta, DataModel.TGroupSpec, DataModel.TGroupStatus> getGroupRepository() {
        return groupRepository;
    }
}
