package ru.yandex.infra.auth.yp;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.infra.controller.dto.SchemaMeta;
import ru.yandex.infra.controller.yp.YpObject;
import ru.yandex.yp.client.api.DataModel;

public class YpGroup {
    private String id;
    private Set<String> members;
    private Map<String,String> labels;

    public YpGroup(String id, Set<String> members, Map<String, String> labels) {
        this.id = id;
        this.members = members;
        this.labels = labels;
    }

    public String getId() {
        return id;
    }

    public Set<String> getMembers() {
        return members;
    }

    public Map<String, String> getLabels() {
        return labels;
    }

    public static YpGroup fromProto(String groupId, YpObject<SchemaMeta, DataModel.TGroupSpec, DataModel.TGroupStatus> group) {
        return new YpGroup(groupId,
                Set.copyOf(group.getSpec().getMembersList()),
                group.getLabels().entrySet().stream()
                        .filter(entry -> entry.getValue().isStringNode())
                        .collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().stringValue())));
    }

}
