package ru.yandex.infra.auth.yp;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import ru.yandex.yp.model.YpTransaction;

public interface YpGroupsClient {
    CompletableFuture<Boolean> exists(String groupId, YpTransaction transaction);

    CompletableFuture<?> addGroup(String id, Set<String> memberIds, YpTransaction transaction, Map<String, Object> labels);

    CompletableFuture<?> removeGroup(String id, YpTransaction transaction);

    CompletableFuture<?> removeGroup(String id);

    CompletableFuture<?> removeGroups(Collection<String> ids);

    CompletableFuture<?> addMembers(String groupId, Set<String> memberIds, YpTransaction transaction);

    CompletableFuture<?> removeMembers(String groupId, Set<String> memberIds, YpTransaction transaction);

    CompletableFuture<?> updateMembers(String groupId, Set<String> memberIds);

    CompletableFuture<?> updateMembers(String groupId, Set<String> memberIds, YpTransaction transaction);

    CompletableFuture<List<String>> getMembers(String groupId, YpTransaction transaction);

    CompletableFuture<Map<String, YpGroup>> getGroupsByLabels(Map<String, String> labels, Optional<Long> transactionTimestamp);

    CompletableFuture<Set<String>> listAllIds();

    CompletableFuture<List<YpAbcRoleGroup>> getAbcRoleGroups();

    CompletableFuture<Map<String, Set<String>>> getGroupsWithPrefix(String prefix);

    CompletableFuture<Map<String, Set<String>>> getGroupsWithLabels(Map<String, String> labels);

    CompletableFuture<Map<String, Set<String>>> getGroupsWithLabels(Map<String, String> labels, long transactionTimestamp);
}
