package ru.yandex.infra.auth.yp;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import ru.yandex.infra.auth.RolesInfo;
import ru.yandex.yp.model.YpTransaction;

public interface YpObjectPermissionsUpdater {
    CompletableFuture<?> addRole(String objectId, String subjectId, List<RolesInfo.RoleAce> aces);

    CompletableFuture<?> addRole(String objectId,
                                 String subjectId,
                                 List<RolesInfo.RoleAce> aces,
                                 YpTransaction transaction);

    CompletableFuture<?> updateRole(String objectId, String subjectId, List<RolesInfo.RoleAce> aces);

    CompletableFuture<?> removeRoles(String objectId, Set<String> subjectIds);
}
