package ru.yandex.infra.auth.yp;

import java.util.Map;
import java.util.Set;

import ru.yandex.infra.auth.TreeNode;
import ru.yandex.infra.controller.dto.SchemaMeta;

public interface YpObjectsTreeGetter {
    class TreeNodeWithTimestamp {
        private final TreeNode treeNode;
        private final Long timestamp;
        private final Map<String, Set<String>> groups;

        public TreeNodeWithTimestamp(TreeNode treeNode, Long timestamp, Map<String, Set<String>> groups) {
            this.treeNode = treeNode;
            this.timestamp = timestamp;
            this.groups = groups;
        }

        public TreeNode getTreeNode() {
            return treeNode;
        }

        public Long getTimestamp() {
            return timestamp;
        }

        public Map<String, Set<String>> getGroups() {
            return groups;
        }
    }

    TreeNodeWithTimestamp getObjectsTree(boolean withMetrics) throws YpObjectsTreeGetterError;

    String getUniqueIdForProjectOrStageIdmNode(SchemaMeta meta);
}
