package ru.yandex.infra.auth.yp;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

import ru.yandex.infra.auth.Role;
import ru.yandex.infra.auth.RoleSubject;
import ru.yandex.infra.auth.RolesInfo;

public interface YpService {
    Set<Role> getRoles() throws YpObjectsTreeGetterError;

    Set<RoleSubject> getRoleSubjects();

    Map<Role, Set<String>> getRoleMembers() throws YpObjectsTreeGetterError, ExecutionException, InterruptedException;

    Map<String, Set<String>> getGroupsWithPrefix(String prefix);

    Map<String, Set<String>> getGroupsWithLabels(Map<String, String> labels);

    Map<String, Set<String>> getRoleMembers(RolesInfo.LevelName level, String objectId);

    String getProjectIdFor(String nannyServiceId);

    List<String> getNannyServices(String projectId);

    void addRoleSubject(RoleSubject roleSubject) throws YpServiceException;

    void updateRoleSubject(RoleSubject roleSubject) throws YpServiceException;

    void removeRoleSubject(RoleSubject roleSubject) throws YpServiceException;

    void addMembersToGroup(String groupId, Set<String> loginsToAdd) throws YpServiceException;

    void syncGroupMembersToAllSlaveClusters(Map<String, String> labels);

    void removeMembersFromGroup(String groupId, Set<String> loginsToRemove) throws YpServiceException;

    void removeGroup(String groupId);

    CompletableFuture<?> removeRolesFromStageAcl(String stageId, Set<Role> removedRoles);

    void setGlobalCleanupFlag();

    Set<String> getGarbageGroups();

    YpClients getMasterClusterClients();

    Map<String, YpClients> getSlaveClusterClients();

    String getSystemName();
}
