package ru.yandex.infra.auth.yp;

import ru.yandex.yp.client.api.AccessControl;

public class YpUtils {
    static public AccessControl.TAccessControlEntry generateACE(
            String subjectId,
            Iterable<AccessControl.EAccessControlPermission> permissions,
            Iterable<String> attributes) {
        return AccessControl.TAccessControlEntry.newBuilder()
                .addSubjects(subjectId)
                .addAllPermissions(permissions)
                .setAction(AccessControl.EAccessControlAction.ACA_ALLOW)
                .addAllAttributes(attributes)
                .build();
    }
}
