# SUPER_USER can approve any roles:
#  - 1 priority approver for system roles and 2 priority approver for project roles
# OWNER can approve roles for its own project (including stages, boxes, etc) except of SYSTEM_DEVELOPER role
#  - 1 priority approver for project roles

SYSTEM_NAME = 'deploy-test'
SYSTEM_ROBOT_NAME = 'robot-deploy-auth'
ROOT = 'ROOT'
SYSTEM_ROLES = ['SYSTEM_DEVELOPER', 'SUPER_USER']
SUPER_USER_ROLE = 'SUPER_USER'
OWNER_ROLE = 'OWNER'

# role_path is same as role ordered from root to leaf
root_role_name = role[ROOT]
role_path = [{ROOT: root_role_name}]
current_slug = root_role_name
role_name = root_role_name
while current_slug in role:
    role_name = role[current_slug]
    role_path.append({current_slug: role_name})
    current_slug = current_slug + "." + role_name

# super-user role
approver_roles = [
    {ROOT : SUPER_USER_ROLE},
]

if role_name not in SYSTEM_ROLES:
    # add project OWNER for project-related roles
    # system roles can be approved by SUPER_USER_ only
    project = role_path[1].keys()[0] if len(role_path) > 1 else {}
    if project:
        approver_roles.append({ROOT: project, project: OWNER_ROLE})

approver_users = []
priority = 1
auto_approved = False
for approver_role in reversed(approver_roles):
    if requester and (requester.has_role(approver_role) or requester == SYSTEM_ROBOT_NAME):
        auto_approved = True
        break

    users = system.all_users_with_role(approver_role)
    if users:
        approver_users.append((users, priority))
        priority += 1

if auto_approved:
    approvers = []
elif len(approver_users) == 0:
    raise AccessDenied(u'This role cannot be granted: no administrators')
else:
    approvers = [any_from(users, priority=priority) for users, priority in approver_users]

if root_role_name == SUPER_USER_ROLE:
    ref_roles = [{
        'system': 'self',
        'role_data': {
            'group': 'system',
            'system_on': SYSTEM_NAME,
            'role': 'roles_manage',
        },
        'role_fields': {'scope': '/'}
    }]

elif role[root_role_name] == OWNER_ROLE:
    ref_roles = [{
        'system': 'self',
        'role_data': {
            'group': 'system',
            'system_on': SYSTEM_NAME,
            'role': 'roles_manage',
        },
        'role_fields': {'scope': '/' + root_role_name + '/'}
    }]

no_email = True
