JAVA_PROGRAM(auth_controller)

JDK_VERSION(11)

OWNER(
    staroverovad
    g:deploy
    g:deploy-orchestration
)

INCLUDE(${ARCADIA_ROOT}/library/java/dependency_management.inc)

SET(LOG4J_VERSION 2.16.0)
SET(JETTY_VERSION 9.4.18.v20190429)
SET(LOGSTASH_LOGBACK_ENCODER 4.11)
SET(LOGBACK 1.2.3)

PEERDIR(
    infra/libs/java/controller/controller
    library/java/tvmauth

    contrib/java/org/apache/logging/log4j/log4j-core/${LOG4J_VERSION}
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl/${LOG4J_VERSION}
    contrib/java/org/apache/logging/log4j/log4j-api/${LOG4J_VERSION}

    contrib/java/net/logstash/logback/logstash-logback-encoder/${LOGSTASH_LOGBACK_ENCODER}
    contrib/java/ch/qos/logback/logback-classic/${LOGBACK}
    contrib/java/ch/qos/logback/logback-core/${LOGBACK}

    contrib/java/org/eclipse/jetty/jetty-server/${JETTY_VERSION}
    contrib/java/org/eclipse/jetty/jetty-servlet/${JETTY_VERSION}
)

EXCLUDE(
    # some clashes inside iceberg-xml
    contrib/java/xml-apis/xml-apis
    contrib/java/log4j/log4j/1.2.17
    # Does not work with current netty version. TODO: update
    contrib/java/io/netty/netty-tcnative-boringssl-static

    contrib/java/net/logstash/logback/logstash-logback-encoder
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl
)

JAVA_SRCS(SRCDIR src/main/java **/*.java)
JAVA_SRCS(SRCDIR src/main/resources **/*)

UBERJAR()

UBERJAR_PATH_EXCLUDE_PREFIX(
    # fix for DEVTOOLS-5190, see also https://stackoverflow.com/a/6743609
    META-INF/DUMMY.DSA
    META-INF/DUMMY.SF
    META-INF/SAXONICA.RSA
    META-INF/SAXONICA.SF
    # fix for https://stackoverflow.com/q/34945438
    META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat
)

LINT(strict)

WITH_JDK()

NEED_CHECK()

END()

RECURSE(ut)
