import inject
from sepelib.core import config as mod_cfg
from awacs import resolver
from awacs.lib import nannyclient, ypclient


def __configure_injector(binder):
    gencfg_client = resolver.GencfgClient.from_config(mod_cfg.get_value('gencfg'))
    binder.bind(resolver.IGencfgClient, gencfg_client)

    nanny_config = dict(mod_cfg.get_value('nanny'))
    nanny_config['url'] = nanny_config['url'].rstrip('/') + '/v2'
    binder.bind(nannyclient.INannyClient, nannyclient.NannyClient.from_config(nanny_config))

    yp_client_factory = ypclient.YpObjectServiceClientFactory.from_config(mod_cfg.get_value('yp'))
    binder.bind(ypclient.IYpObjectServiceClientFactory, yp_client_factory)

    nanny_client = resolver.NannyClient.from_config(
        nanny_config, gencfg_client, yp_client_factory)
    binder.bind(resolver.INannyClient, nanny_client)


def configure_inject():
    inject.clear_and_configure(__configure_injector)


def get_nannyclient():
    return inject.instance(nannyclient.INannyClient)
