# -*- coding: utf-8 -*-
import argparse
import os
import subprocess
import tarfile


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--awacsctl-tool', dest='awacsctl_tool')
    parser.add_argument('--namespace', dest='namespace')
    parser.add_argument('--templates-dir', dest='templates_dir')
    parser.add_argument('--target', dest='target')
    args = parser.parse_args()

    outdir = os.path.join(os.getcwd(), 'bundle')

    process = subprocess.Popen([
        os.path.abspath(args.awacsctl_tool),
        'compile', args.namespace,
        '--outdir', outdir,
        '--templates-dir', args.templates_dir,
    ], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    stdout, stderr = process.communicate()
    if process.returncode:
        raise RuntimeError(stderr)

    with tarfile.open(args.target, 'w:gz') as tar:
        tar.add(outdir, arcname=os.path.basename(outdir))


if __name__ == '__main__':
    main()
