package container

import (
	awacsapi "a.yandex-team.ru/infra/awacs/proto"
	"fmt"
	"github.com/golang/protobuf/jsonpb"
	"os"
)

func ReadBalancerContainerSpec(path string) (*awacsapi.BalancerContainerSpec, error) {
	f, err := os.Open(path)
	if err != nil {
		return nil, fmt.Errorf("failed to open %s: %w", path, err)
	}
	defer f.Close()
	req := awacsapi.BalancerContainerSpec{}
	if err := jsonpb.Unmarshal(f, &req); err != nil {
		return nil, fmt.Errorf("failed to unmarshal %s: %w", path, err)
	}
	return &req, nil
}
