package awacs

import (
	"github.com/go-resty/resty/v2"

	pb "a.yandex-team.ru/infra/awacs/proto"
)

const (
	ProdAPIURL = "https://awacs.yandex-team.ru/api/"
	TestAPIURL = "https://test-awacs.n.yandex-team.ru/api/"
)

type Client interface {
	pb.NamespaceServiceClient
	pb.DnsRecordServiceClient
	pb.L3BalancerServiceClient
	pb.BalancerServiceClient
	pb.BackendServiceClient
	pb.EndpointSetServiceClient
	pb.UpstreamServiceClient
	pb.CertificateServiceClient
	pb.AwacsStatisticsServiceClient
}

type client struct {
	apiURL string
	token  string
	r      *resty.Client
	conn   *conn

	pb.NamespaceServiceClient
	pb.DnsRecordServiceClient
	pb.L3BalancerServiceClient
	pb.BalancerServiceClient
	pb.BackendServiceClient
	pb.EndpointSetServiceClient
	pb.UpstreamServiceClient
	pb.CertificateServiceClient
	pb.AwacsStatisticsServiceClient
}

func NewClient(opts ...Option) *client {
	c := &client{
		apiURL: ProdAPIURL,
		r: resty.New().
			SetHeaders(map[string]string{
				"Accept":       "application/x-protobuf",
				"Content-Type": "application/x-protobuf",
			}),
	}

	for _, opt := range opts {
		opt(c)
	}
	c.r.SetHeader("Authorization", "OAuth "+c.token)

	conn := newConn(c.apiURL, c.r)
	c.NamespaceServiceClient = pb.NewNamespaceServiceClient(conn)
	c.DnsRecordServiceClient = pb.NewDnsRecordServiceClient(conn)
	c.L3BalancerServiceClient = pb.NewL3BalancerServiceClient(conn)
	c.BalancerServiceClient = pb.NewBalancerServiceClient(conn)
	c.BackendServiceClient = pb.NewBackendServiceClient(conn)
	c.EndpointSetServiceClient = pb.NewEndpointSetServiceClient(conn)
	c.UpstreamServiceClient = pb.NewUpstreamServiceClient(conn)
	c.CertificateServiceClient = pb.NewCertificateServiceClient(conn)
	c.AwacsStatisticsServiceClient = pb.NewAwacsStatisticsServiceClient(conn)

	return c
}
