package awacs

import (
	"context"
	"fmt"

	"google.golang.org/genproto/protobuf/field_mask"

	pb "a.yandex-team.ru/infra/awacs/proto"
)

func ExampleClient_ListNamespaces() {
	ctx := context.Background()

	// Create client.
	c := NewClient(WithToken("your-token"))

	// List ids of all namespaces.
	rsp, err := c.ListNamespaces(ctx, &pb.ListNamespacesRequest{
		FieldMask: &field_mask.FieldMask{Paths: []string{"meta"}},
	}, nil)
	if err != nil {
		panic(err)
	}

	for _, n := range rsp.Namespaces {
		fmt.Println(n.Meta.Id)
	}
}

func ExampleClient_GetBalancer() {
	ctx := context.Background()

	// Create client.
	c := NewClient(WithToken("your-token"))

	// Get balancer configuration.
	rsp, err := c.GetBalancer(ctx, &pb.GetBalancerRequest{
		Id:          "your-balancer",
		NamespaceId: "your-namespace",
	}, nil)
	if err != nil {
		panic(err)
	}

	fmt.Println(rsp.GetBalancer().GetSpec().GetYandexBalancer().Yaml)
}

func ExampleClient_CreateBalancer() {
	ctx := context.Background()

	// Create client.
	c := NewClient(WithToken("your-token"))

	// Create balancer
	_, err := c.CreateBalancer(ctx, &pb.CreateBalancerRequest{
		Meta: &pb.BalancerMeta{
			NamespaceId: "test-namespace",
			Id:          "test-balancer",
		},
	}, nil)

	fmt.Println(err)
}
