package awacs

type Option func(*client)

func WithToken(token string) Option {
	return func(c *client) {
		c.token = token
	}
}

func WithDebug() Option {
	return func(c *client) {
		c.r.Debug = true
	}
}

func WithTestAPI() Option {
	return WithAPIURL(TestAPIURL)
}

func WithAPIURL(url string) Option {
	return func(c *client) {
		c.apiURL = url
	}
}
