
from collections import OrderedDict
import io
import yaml


def ordered_dump(data, stream=None, Dumper=yaml.Dumper, **kwds):  # pylint: disable=invalid-name
    """Missing function docstring"""

    class OrderedDumper(Dumper):  # pylint: disable=too-many-ancestors
        """Missing function docstring"""
        pass

    def ignore_aliases(self, data):
        return True

    def _dict_representer(dumper, data):
        return dumper.represent_mapping(
            yaml.resolver.BaseResolver.DEFAULT_MAPPING_TAG,
            data.items()
        )

    OrderedDumper.add_representer(OrderedDict, _dict_representer)
    return yaml.dump(data, stream, OrderedDumper, **kwds)


class ExplicitDumper(yaml.SafeDumper):
    """
    A dumper that will never emit aliases.
    """

    def ignore_aliases(self, data):
        return True


def write_to_file(fname, data):
    with io.open(
        '{}.yaml'.format(fname),
        'w',
        encoding='utf-8'
    ) as outfile:
        outfile.write(
            six.text_type(
                ordered_dump(
                    data,
                    Dumper=ExplicitDumper,
                    explicit_start=True
                )
            )
        )
