#!/usr/bin/env python
# coding: utf-8
"""Script for generate examples of distribution traffic across backends"""

from collections import OrderedDict
import common


def generated_balancer_options(backend, key, value):
    """Missing function docstring"""
    balancer_type = 'weighted2'
    if key == 'by_hash_policy':
        balancer_type = 'rr'
    elif key == 'double_hashing':
        balancer_type = 'hashing'

    policies = ('unique_policy', {})
    no_unique_policy_keys = (
        'by_hash_policy',
        'timeout_policy_02',
        'timeout_policy_03'
    )
    if key in no_unique_policy_keys:
        policies = value['policies']

    balancer_options = OrderedDict([
        ('attempts', 3),
        (balancer_type, {}),
        policies,
        (
            'generated_proxy_backends', OrderedDict([
                ('proxy_options', {
                    'connect_timeout': '100ms',
                    'backend_timeout': '5s'
                }),
                ('include_backends', {
                    'type': 'BY_ID',
                    'ids': [backend]
                })
            ])
        )
    ])

    return balancer_options


def generate_custom_backends(backends, key, value):
    """Missing function docstring"""
    custom_backends = [
        OrderedDict([
            ('weight', 1),
            ('name', 'test_{}'.format(geo)),
            ('modules', [
                {
                    'report': {
                        'uuid': 'test_requests_to_{}'.format(geo),
                        'ranges': 'default'
                    },
                },
                {'stats_eater': {}},
                {'balancer2': generated_balancer_options(backend, key, value)}
            ])
        ]) for geo, backend in backends.iteritems()
    ]

    custom_backends.append(OrderedDict([
        ('weight', -1),
        ('name', 'test_devnull'),
        ('modules', [
            {
                'report': {
                    'uuid': 'test_requests_to_devnull',
                    'ranges': '1ms'
                }
            },
            {
                'errordocument': {'status': 204}
            }
        ])
    ]))

    return custom_backends


def gen_modules(key, value, backends):
    """Missing function docstring"""
    policies = value['policies']
    if key == 'timeout_policy_03':
        policies = ('unique_policy', {})

    return {
        'modules': [
            {
                'balancer2': OrderedDict([
                    ('attempts', 1),
                    ('rr', {
                        'weights_file': './controls/traffic_control.weights'
                    }),
                    policies,
                    ('backends', generate_custom_backends(backends, key, value)),
                    ('on_error', {
                        'modules': [
                            {
                                'errordocument': {
                                    'status': '504',
                                    'content': 'Service unavailable'
                                }
                            }
                        ]
                    })
                ])
            }
        ]
    }


def main():
    """Missing function docstring"""
    backends = OrderedDict([
        (geo, 'test_{}_backend'.format(geo)) for geo in ('man', 'vla', 'sas')
    ])
    data = {
        'by_name_policy': {
            'policies': (
                'by_name_policy', {
                    'name': 'test_man',
                    'unique_policy': {}
                }
            )
        },
        'simple_full_mesh': {
            'policies': ('unique_policy', {})
        },
        'by_hash_policy': {
            'policies': (
                'by_hash_policy', {
                    'unique_policy': {}
                }
            )
        },
        'double_hashing': {
            'policies': ('unique_policy', {})
        },
        'timeout_policy_01': {
            'policies': (
                'timeout_policy', {
                    'timeout': '1s',
                    'unique_policy': {}
                }
            )
        },
        'timeout_policy_02': {
            'policies': (
                'timeout_policy', {
                    'timeout': '1s',
                    'unique_policy': {}
                }
            )
        },
        'timeout_policy_03': {
            'policies': (
                'timeout_policy', {
                    'timeout': '1s',
                    'unique_policy': {}
                }
            )
        }
    }

    for key, value in data.iteritems():
        result = gen_modules(key, value, backends)

        common.write_to_file(
            fname='{}_example'.format(key),
            data=result
        )


if __name__ == '__main__':
    main()
