"""Script for generate upstreams of collections.test.yandex.ru"""

from collections import OrderedDict
import io
import yaml
import allmodules as Data


def ordered_dump(data, stream=None, Dumper=yaml.Dumper, **kwds):  # pylint: disable=invalid-name
    """Missing function docstring"""

    class OrderedDumper(Dumper):  # pylint: disable=too-many-ancestors
        """Missing function docstring"""
        pass

    def ignore_aliases(self, data):
        return True

    def _dict_representer(dumper, data):
        return dumper.represent_mapping(
            yaml.resolver.BaseResolver.DEFAULT_MAPPING_TAG,
            data.items())

    OrderedDumper.add_representer(OrderedDict, _dict_representer)
    return yaml.dump(data, stream, OrderedDumper, **kwds)


class ExplicitDumper(yaml.SafeDumper):
    """
    A dumper that will never emit aliases.
    """

    def ignore_aliases(self, data):
        return True


def gen_modules(host, d3l, backends, attempts, backend_timeout, timeout_policy=False):
    """Missing function docstring"""

    return {
        'balancer2': OrderedDict([
            ('attempts', attempts),
            ('weighted2', {}),
            (
                'timeout_policy' if timeout_policy else 'unique_policy',
                OrderedDict([('timeout', '100ms'), ('unique_policy', {})]) if timeout_policy else {}
            ),
            ('generated_proxy_backends', OrderedDict([
                ('proxy_options', OrderedDict([
                    ('backend_timeout', backend_timeout),
                    ('connect_timeout', '40ms')
                ])),
                ('include_backends', OrderedDict([
                    ('type', 'BY_ID'),
                    ('ids', [backends])
                ]))
            ]))
        ])
    }


def main():
    """Missing function docstring"""
    for i, item in enumerate(Data.data):
        matcher = {
            'match_fsm': {
                'host': '{0}\\\\.{1}\\\\.yandex\\\\.net'.format(
                    item['host'],
                    item.get('d3l', 'noapache')
                )
            }
        }

        default_section_modules = [
            gen_modules(
                item['host'],
                item.get('d3l', None),
                item['backends'],
                item.get('attempts', 5),
                item.get('backend_timeout', '10s')
            )
        ]

        if item.get('d3l') == 'apphost':
            modules = [
                {
                    'regexp': {
                        'sections': OrderedDict([
                            (
                                'jsonctxweb0',
                                {
                                    'matcher': {
                                        'match_fsm': {
                                            'uri': '/(_json|_ctx)/(_ctx|_json)/web0(.*)?'
                                        }
                                    },
                                    'modules': [gen_modules(
                                        item['host'],
                                        'apphost',
                                        item['backends'],
                                        1,
                                        '100ms',
                                        timeout_policy=True
                                    )]
                                }
                            ),
                            ('default', {
                                'matcher': {},
                                'modules': default_section_modules
                            })
                        ])
                    }
                }
            ]
        else:
            modules = default_section_modules

        result = {
            'regexp_section': {
                'matcher': matcher,
                'modules': modules
            }
        }

        with io.open(
            '{}_upstream_{}_{}.yaml'.format(
                '{:08d}'.format(1000 + 100 * i),
                item['host'],
                item.get('d3l', 'noapache')
            ),
            'w',
            encoding='utf-8'
        ) as outfile:
            outfile.write(
                six.text_type(
                    ordered_dump(
                        result,
                        Dumper=ExplicitDumper,
                        explicit_start=True
                    )
                )
            )


if __name__ == '__main__':
    main()
