# coding: utf-8

import click
import juggler_sdk

from infra.awacs.tools.awacsalerting.src import context


@click.group('juggler-check-testing', help='Create juggler check in namespace')
@click.option('--juggler-oauth-token', type=click.STRING, envvar='JUGGLER_OAUTH_TOKEN', required=True)
@context.pass_cli_context
def cli(cli_context, juggle_oauth_token):
    cli_context.juggler_api_token = juggle_oauth_token


@cli.command('deploy-status', help='create nanny deploy status check')
@click.argument('namespace-id')
@context.pass_cli_context
def deploy_status(cli_context, namespace_id):
    assert cli_context.juggler_api_token

    def create_check(ns_id, _location, b_pb):
        nanny_service_id = b_pb.spec.config_transport.nanny_static_file.service_id
        ns_id_norm = ns_id.replace('.', '-').replace('_', '-')
        return juggler_sdk.Check(
            service='deploy_monitoring',
            host='awacs.{}.{}'.format(ns_id_norm, _location.lower()),
            namespace=u'awacs.{}'.format(ns_id_norm),
            tags=[
                u'awacs_balancer_id_{}'.format(balancer_pb.meta.id),
                'cplb',
                u'awacs_namespace_id_{}'.format(ns_id),
                namespace_id,
                u'awacs_notify_group_testing_group'
            ],
            active='nanny_deploy_status',
            active_kwargs={
                'service': nanny_service_id,

                'warn': 300,
                'crit': 600,
            },
            meta={
                'urls': [
                    {
                        'url': 'https://nanny.yandex-team.ru/ui/#/services/catalog/{}/'.format(nanny_service_id),
                        'type': 'nanny',
                        'title': u'⚠Сервис в nanny'
                    },
                ]
            }
        )

    balancer_pbs = cli_context.list_balancers_pbs(namespace_id)
    juggler_checks = []
    for balancer_pb in balancer_pbs:
        location = balancer_pb.meta.location.yp_cluster
        juggler_checks.append(create_check(namespace_id, location, balancer_pb))

    changed_count = 0
    juggler_url = u'http://juggler-api.search.yandex.net'
    _ns_id_norm = namespace_id.replace('.', '-').replace('_', '-')
    juggler_namespace = u'awacs.{}'.format(_ns_id_norm)
    mark = '{}_{}_testing_checks'.format('awacs', _ns_id_norm)
    with juggler_sdk.JugglerApi(juggler_url, mark=mark, oauth_token=cli_context.juggler_api_token) as api:
        for check in juggler_checks:
            check.namespace = juggler_namespace
            result = api.upsert_check(check)
            if result.changed:
                changed_count += 1
