from infra.awacs.proto import modules_pb2

from awacs.wrappers.base import ValidationCtx
from awacs.wrappers.l7macro import L7Macro
from awacs.wrappers.main import Holder
from .model import BaseBalancerSuggester, clone_pb


class Checker(BaseBalancerSuggester):
    RULE = 'TLEM2FULL'

    def __init__(self, namespace_id, balancer_id):
        super(Checker, self).__init__(namespace_id, balancer_id)
        self.opts = {}

    def suggest(self, balancer_spec_pb, domain_spec_pbs=None, cert_spec_pbs=None):
        config_pb = clone_pb(balancer_spec_pb.yandex_balancer.config)
        h = Holder(config_pb)
        assert isinstance(h.module, L7Macro), repr(type(h.module))
        ctx = ValidationCtx(domain_config_pbs={id_: d_pb.yandex_balancer.config
                                               for id_, d_pb in domain_spec_pbs.items()},
                            certs=cert_spec_pbs)
        h.expand_immediate_contained_macro(ctx=ctx)
        rv_pb = modules_pb2.Holder()
        rv_pb.instance_macro.CopyFrom(h.pb.instance_macro)
        return True, '', rv_pb
