from .model import BaseBalancerSuggester, clone_pb


def list_set_fields(pb):
    return {desc.name for desc, value in pb.ListFields()}


class Checker(BaseBalancerSuggester):
    RULE = 'TLEMNOCOMPAT'

    def __init__(self, namespace_id, balancer_id):
        super(Checker, self).__init__(namespace_id, balancer_id)

    def suggest(self, balancer_spec_pb):
        config_pb = balancer_spec_pb.yandex_balancer.config
        if not config_pb.HasField('l7_macro'):
            return False, 'not an l7_macro', None

        ports = []
        l7_macro = clone_pb(config_pb.l7_macro)
        if l7_macro.HasField('compat'):
            l7_macro.compat.disable_sd = False
            l7_macro.compat.disable_tcp_listen_queue_limit = False
            l7_macro.compat.ClearField('maxconn')
        if l7_macro.HasField('http'):
            ports.extend(l7_macro.http.ports or [80])

        if l7_macro.HasField('http') and l7_macro.http.HasField('compat'):
            l7_macro.http.compat.assign_shared_uuid = ''
            l7_macro.http.compat.refer_shared_uuid = ''
            l7_macro.http.compat.bind_on_instance_port = False
            if not list_set_fields(l7_macro.http.compat):
                l7_macro.http.ClearField('compat')

        if l7_macro.HasField('https'):
            ports.extend(l7_macro.https.ports or [443])

        if l7_macro.HasField('https') and l7_macro.https.HasField('compat'):
            l7_macro.https.compat.assign_shared_uuid = ''
            l7_macro.https.compat.refer_shared_uuid = ''
            l7_macro.https.compat.enable_sslv3 = False
            l7_macro.https.compat.place_first = False
            l7_macro.https.compat.bind_on_instance_port = False
            if not list_set_fields(l7_macro.https.compat):
                l7_macro.https.ClearField('compat')

        if not list_set_fields(l7_macro.compat):
            l7_macro.ClearField('compat')

        # nanny_service_id = balancer_spec_pb.config_transport.nanny_static_file.service_id
        # if l7_macro.http.compat.bind_on_instance_port or l7_macro.https.compat.bind_on_instance_port:
        #    print('xxx: {}/{} {} {}'.format(self.namespace_id, self.balancer_id, nanny_service_id,
        #                                    ','.join(map(str, ports))))

        return True, '', l7_macro
