from infra.awacs.proto import modules_pb2

from awacs.wrappers.main import Holder, L7UpstreamMacro
from .model import BaseUpstreamSuggester, clone_pb


class Checker(BaseUpstreamSuggester):
    RULE = 'UEM2FULL'

    def __init__(self, namespace_id, upstream_id):
        super(Checker, self).__init__(namespace_id, upstream_id)
        self.opts = {}

    @classmethod
    def get_nested(cls, holder_pb):
        h = Holder(holder_pb)
        assert not h.is_empty()
        return next(h.walk_chain())

    def suggest(self, upstream_id, upstream_spec_pb):
        config_pb = clone_pb(upstream_spec_pb.yandex_balancer.config)
        h = Holder(config_pb)
        assert isinstance(h.module, L7UpstreamMacro), repr(type(h.module))
        rv_pb = modules_pb2.Holder()
        rv_pb.regexp_section.CopyFrom(h.module.to_regexp_section_pb())

        h.expand_immediate_contained_macro()

        rv_pb.regexp_section.nested.CopyFrom(h.pb)

        return True, '', rv_pb
