from infra.awacs.proto import modules_pb2

from .model import BaseUpstreamSuggester, clone_pb


def list_set_fields(pb):
    return {desc.name for desc, value in pb.ListFields()}


class Checker(BaseUpstreamSuggester):
    RULE = 'UEMNOCOMPAT'

    def __init__(self, namespace_id, balancer_id):
        super(Checker, self).__init__(namespace_id, balancer_id)

    def suggest(self, upstream_id, upstream_spec_pb):
        mode = 'xxx'
        config_pb = upstream_spec_pb.yandex_balancer.config
        if not config_pb.HasField('l7_upstream_macro'):
            return False, 'not an l7_upstream_macro', None

        l7_upstream_macro = clone_pb(config_pb.l7_upstream_macro)
        if mode == 'xxx':
            if l7_upstream_macro.HasField('compat'):
                return False, 'has compat', None
            balancer_pb = None
            if l7_upstream_macro.HasField('by_dc_scheme'):
                balancer_pb = l7_upstream_macro.by_dc_scheme.balancer

                db_balancer_pb = l7_upstream_macro.by_dc_scheme.dc_balancer
                if db_balancer_pb.HasField('compat'):
                    return False, 'has dcb compat', None
            elif l7_upstream_macro.HasField('flat_scheme'):
                balancer_pb = l7_upstream_macro.flat_scheme.balancer
            if balancer_pb:
                if balancer_pb.HasField('compat'):
                    fs = balancer_pb.compat.ListFields()
                    if len(fs) > 1 or (fs and fs[0][0].name != 'method'):
                        return False, 'has b compat', None
                if balancer_pb.health_check.HasField('compat'):
                    return False, 'has hc compat', None

        elif mode == 'wm':
            balancer_pb = None
            if l7_upstream_macro.HasField('by_dc_scheme'):
                balancer_pb = l7_upstream_macro.by_dc_scheme.balancer
            elif l7_upstream_macro.HasField('flat_scheme'):
                balancer_pb = l7_upstream_macro.flat_scheme.balancer
            if balancer_pb:
                if balancer_pb.HasField('compat') and balancer_pb.compat.HasField('watermark_policy'):
                    wm_policy_pb = balancer_pb.compat.watermark_policy
                    assert wm_policy_pb.lo and wm_policy_pb.hi and wm_policy_pb.lo == wm_policy_pb.hi
                    balancer_pb.max_reattempts_share = wm_policy_pb.lo
                    balancer_pb.compat.ClearField('watermark_policy')

                if not list(balancer_pb.compat.ListFields()):
                    balancer_pb.ClearField('compat')
        elif mode == 'all':
            if l7_upstream_macro.HasField('compat') and l7_upstream_macro.compat.disable_monitoring:
                l7_upstream_macro.compat.disable_monitoring = False

            if l7_upstream_macro.compat == modules_pb2.L7UpstreamMacro.Compat():
                l7_upstream_macro.ClearField('compat')

            if l7_upstream_macro.HasField('by_dc_scheme'):
                for dc_pb in l7_upstream_macro.by_dc_scheme.dcs:
                    if dc_pb.HasField('compat') and dc_pb.compat.disable_monitoring:
                        dc_pb.compat.disable_monitoring = False

                    if (dc_pb.compat == modules_pb2.L7UpstreamMacro.Dc.Compat()
                        and not list(dc_pb.compat.ListFields())):
                        dc_pb.ClearField('compat')

                if l7_upstream_macro.by_dc_scheme.HasField('devnull'):
                    if l7_upstream_macro.by_dc_scheme.devnull.HasField(
                        'compat') and l7_upstream_macro.by_dc_scheme.devnull.compat.disable_monitoring:
                        l7_upstream_macro.by_dc_scheme.devnull.compat.disable_monitoring = False

                    if not list(l7_upstream_macro.by_dc_scheme.devnull.compat.ListFields()):
                        l7_upstream_macro.by_dc_scheme.devnull.ClearField('compat')

                if l7_upstream_macro.by_dc_scheme.compat.disable_devnull:
                    l7_upstream_macro.by_dc_scheme.compat.disable_devnull = False

                if not list(l7_upstream_macro.by_dc_scheme.compat.ListFields()):
                    l7_upstream_macro.by_dc_scheme.ClearField('compat')

                if l7_upstream_macro.by_dc_scheme.dc_balancer.compat.disable_dynamic_weights:
                    l7_upstream_macro.by_dc_scheme.dc_balancer.compat.disable_dynamic_weights = False

                if not list(l7_upstream_macro.by_dc_scheme.dc_balancer.compat.ListFields()):
                    l7_upstream_macro.by_dc_scheme.dc_balancer.ClearField('compat')
        return True, '', l7_upstream_macro
