import click
from awacs.yamlparser.core import dump as dump_pb
from infra.awacs.tools.awacsemtool2.rules.tlem2full import Checker
from infra.awacs.tools.awacstoolslib.util import cli, App


@cli.command()
@click.pass_obj
@click.option('--namespace-id', required=True)
@click.option('--balancer-id', required=True)
def tlem2full(app: App, namespace_id, balancer_id):
    a = app.awacs_client
    balancer_pb = a.get_balancer(namespace_id, balancer_id)
    domain_spec_pbs = {(dom_pb.meta.namespace_id, dom_pb.meta.id): dom_pb.spec
                       for dom_pb in a.list_domains(namespace_id)}
    cert_spec_pbs = {(cert_pb.meta.namespace_id, cert_pb.meta.id): cert_pb.spec
                     for cert_pb in a.list_certs(namespace_id)}
    ok, msg, balancer_config_pb = Checker(namespace_id, balancer_id).suggest(
        balancer_pb.spec, domain_spec_pbs=domain_spec_pbs, cert_spec_pbs=cert_spec_pbs)
    print(dump_pb(balancer_config_pb))
