import click
from awacs.yamlparser.core import dump as dump_pb
from infra.awacs.tools.awacsemtool2.rules.uem2full import Checker
from infra.awacs.tools.awacstoolslib.util import cli, App


@cli.command()
@click.pass_obj
@click.option('--namespace-id', required=True)
@click.option('--upstream-id', required=True)
def uem2full(app: App, namespace_id, upstream_id):
    a = app.awacs_client
    upstream_pb = a.get_upstream(namespace_id, upstream_id)
    ok, msg, upstream_config_pb = Checker(namespace_id, upstream_id).suggest(
        upstream_id, upstream_spec_pb=upstream_pb.spec)
    print(dump_pb(upstream_config_pb))
