import difflib

from colorama import Fore

from awacs.model.db import MongoStorage as BaseMongoStorage


def color_diff(diff):
    for line in diff:
        if line.startswith('+'):
            yield Fore.GREEN + line + Fore.RESET
        elif line.startswith('-'):
            yield Fore.RED + line + Fore.RESET
        elif line.startswith('^'):
            yield Fore.BLUE + line + Fore.RESET
        else:
            yield line


def get_diff(a, b):
    a = a.splitlines(1)
    b = b.splitlines(1)
    diff = difflib.unified_diff(a, b)
    diff = color_diff(diff)
    return ''.join(diff)


class MongoStorage(BaseMongoStorage):
    def __init__(self, db):
        self.db = db

    @property
    def _db(self):
        return self.db


def clone_pb(pb):
    cloned_pb = type(pb)()
    cloned_pb.CopyFrom(pb)
    return cloned_pb


def clone_pb_dict(d):
    return {k: clone_pb(pb) for k, pb in d.items()}
