from __future__ import unicode_literals

from library.python.vault_client.instances import Production as YavClient


class YavGetter(object):
    def __init__(self, vault_client):
        """
        :type vault_client: YavClient
        """
        self.__vault_client = vault_client

    def get_secret(self, name, version, key=None):
        """
        :type name: six.text_type
        :type version: six.text_type
        :type key: six.text_type | None
        """
        try:
            data = self.__vault_client.get_version(version=version, decode_files=True)
        except Exception as e:
            raise ValueError('failed to get secret "{}:{}" from yav: {}'.format(name, version, e))

        if data['secret_name'] != name:
            raise ValueError(
                'version "{}" belongs to yav secret "{}", not "{}"'.format(version, data['secret_name'], name))

        if key is None:
            n = len(data['value'])
            if n == 1:
                return next(iter(data['value'].values()))
            elif n > 1:
                raise ValueError(
                    'yav secret "{}:{}" contains multiple keys, key must be specified'.format(name, version))
            else:
                raise ValueError('yav secret "{}:{}" has no keys, how come?'.format(name, version))
        elif key in data['value']:
            return data['value'][key]
        else:
            raise ValueError('yav secret "{}:{}" does not contain key "{}"'.format(name, version, key))

    @classmethod
    def get_yav_with_oauth(cls, oauth_token_path):
        with open(oauth_token_path, 'rb') as f:
            oauth_token = f.read().strip()
        return YavGetter(YavClient(authorization='OAuth {}'.format(oauth_token)))

    @classmethod
    def get_yav_with_rsa_auth(cls, rsa_login, rsa_private_key_path):
        with open(rsa_private_key_path, 'rb') as f:
            private_key = f.read().strip()
        return YavGetter(YavClient(rsa_auth=private_key, rsa_login=rsa_login))
