from .model import BaseVisitor


class UpstreamChecker(BaseVisitor):
    RULE = 'ARL'

    def check_Balancer2(self, module, path):
        is_terminal = module.generated_proxy_backends
        if is_terminal and not module.attempts_rate_limiter and module.pb.attempts != 1:
            self.warn(path, 'ATTEMPTS_LIMITER_DISABLED', severity=8, tags={'no-attempts-rate-limiter'})
