from .model import BaseVisitor


class UpstreamChecker(BaseVisitor):
    RULE = 'AWACS736'

    attributes = ['pattern', 'replacement']

    def check_L7UpstreamMacro(self, module, path):
        if not module.rewrite:
            return

        for rewrite_pb in module.rewrite:
            errors = []
            for attribute in self.attributes:
                if not str(getattr(rewrite_pb.pb, attribute)):
                    errors.append(attribute)

            if errors:
                self.warn(path, '{}: missing {}'.format(self.RULE, ', '.join(errors)), severity=2, tags={self.RULE})
