from .model import BaseVisitor


class UpstreamChecker(BaseVisitor):
    RULE = 'AWACS976'

    def check_RpsLimiter(self, module, path):
        if not module.on_error:
            return
        self.warn(path, '{}: rps_limiter.on_error is used'.format(self.RULE), severity=2, tags={self.RULE})


class BalancerChecker(BaseVisitor):
    RULE = 'AWACS976'

    def check_RpsLimiter(self, module, path):
        if not module.on_error:
            return
        self.warn(path, '{}: rps_limiter.on_error is used'.format(self.RULE), severity=2, tags={self.RULE})
