from .model import BaseVisitor


class BalancerChecker(BaseVisitor):
    RULE = 'BALANCER2982'

    def check_Balancer2(self, module, path):
        if ((module.active or (module.dynamic and module.dynamic.active)) and
            module.generated_proxy_backends.endpoint_sets):
            self.warn(path, 'BALANCER2982', severity=8, tags={'BALANCER-2982'})


"""
class UpstreamChecker(BaseVisitor):
    RULE = 'BALANCER2982'


    def check_L7UpstreamMacro(self, module, path):
        if module.by_dc_scheme:
            if module.by_dc_scheme.balancer.health_check:
                self.warn(path, 'BALANCER2982', severity=8, tags={'BALANCER-2982'})
        if module.flat_scheme:
            if module.flat_scheme.balancer.health_check:
                self.warn(path, 'BALANCER2982', severity=8, tags={'BALANCER-2982'})
"""
