import re

from .model import BaseVisitor


class UpstreamChecker(BaseVisitor):
    RULE = 'BEGEMOT_CHECK'

    def check_Balancer2(self, module, path):
        backends = module.generated_proxy_backends
        backend_timeout = 0
        if (backends):
            if (not backends.pb.proxy_options.backend_timeout):
                self.warn(path, 'No backend_timeout', severity=3, tags={'test'})
            else:
                backend_timeout = int(re.sub('[a-zA-z]*', '', backends.pb.proxy_options.backend_timeout))
                has_bg_timeout = False
                for mod in path:
                    if (mod[0] == 'rewrite'):
                        rewrite = mod[1]
                        for action in rewrite.actions:
                            arg = str(action.pb.rewrite)
                            if ('bg_timeout' in arg):
                                has_bg_timeout = True
                                bg_timeout = int(arg[(arg.find('=') + 1):])
                                if (bg_timeout != backend_timeout):
                                    self.warn(path, 'Bg_timeout not equal to backend_timeout', severity=1,
                                              tags={'test'})
                if (not has_bg_timeout):
                    self.warn(path, 'You should specify bg_timeout for balancer2 with backend_timeout', severity=2,
                              tags={'test'})
