from .model import BaseVisitor


class BalancerChecker(BaseVisitor):
    RULE = 'SWAT6294'

    def check_Balancer2(self, module, path):
        if module.generated_proxy_backends and module.generated_proxy_backends.endpoint_sets:
            fast_attempts = module.get('fast_attempts')
            if fast_attempts.value and fast_attempts.is_func() \
                and fast_attempts.value.func_name == 'count_backends' and \
                not fast_attempts.value.func_params.pb.compat_enable_sd_support.value:
                self.warn(path, 'SWAT6294', severity=9, tags={'total'})
            else:
                connection_attempts = module.get('connection_attempts')
                if connection_attempts.value and connection_attempts.is_func() \
                    and connection_attempts.value.func_name == 'count_backends' and \
                    not connection_attempts.value.func_params.pb.compat_enable_sd_support.value:
                    self.warn(path, 'SWAT6294', severity=9, tags={'total'})
