import re

from .model import BaseVisitor


TIMEDELTA_RE = re.compile(r'^([0-9]+)(\.[0-9]+)?(ms|s|m)$')


class UpstreamChecker(BaseVisitor):
    RULE = 'SWAT7184'

    def check_L7UpstreamMacro(self, module, path):
        if module.static_response:
            return
        balancer_pb = (module.flat_scheme or module.by_dc_scheme).balancer.pb

        for f in ('connect_timeout', 'backend_timeout', 'backend_read_timeout', 'backend_write_timeout',
                  'client_read_timeout', 'client_write_timeout', 'client_read_timeout'):
            timeout = getattr(balancer_pb, f)
            if timeout:
                if not TIMEDELTA_RE.match(timeout):
                    self.warn(path, 'SWAT7184: {} = {}'.format(f, timeout), severity=2, tags={'SWAT7184'})
