import re

from awacs.wrappers.main import Report

from .model import BaseVisitor


class BalancerChecker(BaseVisitor):
    RULE = 'INVALID_UUID'
    UUID_RE = '^[,a-z0-9-_]+$'

    def check_Report(self, module, path):
        assert isinstance(module, Report)
        if module.pb.uuid and not re.match(self.UUID_RE, module.pb.uuid):
            self.warn(path, 'invalid_uuid', tags={'invalid_uuid'})
