from .model import BaseVisitor


class BalancerChecker(BaseVisitor):
    RULE = 'SWAT7451'

    def check_Balancer2(self, module, path):
        if module.generated_proxy_backends:
            if not module.balancing_policy:
                return
            policy_kinds = module.balancing_policy.list_policy_kinds()
            if 'active_policy' not in policy_kinds:
                return
            if not policy_kinds:
                return
            it = iter(policy_kinds)
            kind = next(it)
            policy = getattr(module.balancing_policy, kind)

            active_policy = None
            while 1:
                if kind == 'active_policy':
                    active_policy = policy
                    break
                kind = next(it)
                policy = getattr(policy.balancing_policy, kind)
            assert active_policy is not None

            skip_attempts = active_policy.get('skip_attempts')
            if skip_attempts.value and skip_attempts.is_func() \
                and skip_attempts.value.func_name == 'count_backends' \
                and not skip_attempts.value.pb.count_backends_params.compat_enable_sd_support.value:
                self.warn(path, 'SWAT7451', severity=9, tags={'total'})
