from .model import BaseVisitor


class BalancerChecker(BaseVisitor):
    RULE = 'SWAT7537'

    def check_Balancer2(self, module, path):
        if not module.balancing_policy:
            return
        policy_kinds = module.balancing_policy.list_policy_kinds()
        if 'active_policy' not in policy_kinds:
            return
        i = policy_kinds.index('active_policy')
        tail = policy_kinds[i + 1:]
        if tail != ['unique_policy']:
            self.warn(path, 'SWAT7537: {}'.format(policy_kinds), severity=9, tags={'total'})
